/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;

public class MachineId
implements Serializable {
    static final long serialVersionUID = 5505875758577820946L;
    private static final String TRACE_MASKD = "XFCSMIDD";
    private static final String TRACE_MASKF = "XFCSMIDF";
    private static final String TRACE_MASKT = "XFCSMIDT";
    private String name;
    private String group;
    private double version;
    private int type;
    private int fcsVersion;
    private InetAddress[] nicAddresses;
    private boolean[] publicNetworkIndicators;
    private String[] macAddresses;
    private String machineType;
    private String machineModel;
    private String machineSerial;

    public MachineId(String name, String group, double version, int type, int fcsVersion, InetAddress[] nicAddresses) {
        if (name == null) {
            throw new IllegalArgumentException("Name passed to MachineId can not be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("Group passed to MachineId can not be null");
        }
        if (nicAddresses == null) {
            throw new IllegalArgumentException("NICAddresses passed to MachineId can not be null");
        }
        if (nicAddresses.length < 1) {
            throw new IllegalArgumentException("NICAddresses passed to MachineId must have at least one member");
        }
        this.name = name;
        this.group = group;
        this.version = version;
        this.type = type;
        this.fcsVersion = fcsVersion;
        this.nicAddresses = nicAddresses;
        this.publicNetworkIndicators = new boolean[nicAddresses.length];
    }

    public MachineId(String name, String group, double version, int type, int fcsVersion, InetAddress[] nicAddresses, boolean[] publicNetworkIndicators) {
        if (name == null) {
            throw new IllegalArgumentException("Name passed to MachineId can not be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("Group passed to MachineId can not be null");
        }
        if (nicAddresses == null) {
            throw new IllegalArgumentException("NICAddresses passed to MachineId can not be null");
        }
        if (nicAddresses.length < 1) {
            throw new IllegalArgumentException("NICAddresses passed to MachineId must have at least one member");
        }
        if (publicNetworkIndicators == null) {
            throw new IllegalArgumentException("publicNetworkIndicators passed to MachineId can not be null");
        }
        if (publicNetworkIndicators.length != nicAddresses.length) {
            throw new IllegalArgumentException("publicNetworkIndicators passed to MachineId must have the same number of members as NICAddresses");
        }
        this.name = name;
        this.group = group;
        this.version = version;
        this.type = type;
        this.fcsVersion = fcsVersion;
        this.nicAddresses = new InetAddress[nicAddresses.length];
        System.arraycopy(nicAddresses, 0, this.nicAddresses, 0, nicAddresses.length);
        this.publicNetworkIndicators = new boolean[publicNetworkIndicators.length];
        for (int i = 0; i < publicNetworkIndicators.length; ++i) {
            this.publicNetworkIndicators[i] = publicNetworkIndicators[i];
        }
    }

    public MachineId(String name, String group, double version, int type, int fcsVersion, InetAddress[] nicAddresses, boolean[] publicNetworkIndicators, String machineType, String machineModel, String machineSerial) {
        this(name, group, version, type, fcsVersion, nicAddresses, publicNetworkIndicators);
        this.machineType = machineType;
        this.machineModel = machineModel;
        this.machineSerial = machineSerial;
    }

    public MachineId(String name, String group, double version, int type, int fcsVersion, InetAddress[] nicAddresses, boolean[] publicNetworkIndicators, String[] macAddresses, String machineType, String machineModel, String machineSerial) {
        this(name, group, version, type, fcsVersion, nicAddresses, publicNetworkIndicators, machineType, machineModel, machineSerial);
        if (macAddresses != null && macAddresses.length != nicAddresses.length) {
            throw new IllegalArgumentException("MAC address array must be the same length as NIC address array");
        }
        if (macAddresses != null) {
            this.macAddresses = new String[macAddresses.length];
            System.arraycopy(macAddresses, 0, this.macAddresses, 0, macAddresses.length);
        } else {
            this.macAddresses = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public double getVersion() {
        return this.version;
    }

    public int getType() {
        return this.type;
    }

    public int getFcsVersion() {
        return this.fcsVersion;
    }

    public InetAddress[] getNicAddresses() {
        InetAddress[] nicAddressesCopy = new InetAddress[this.nicAddresses.length];
        System.arraycopy(this.nicAddresses, 0, nicAddressesCopy, 0, this.nicAddresses.length);
        return nicAddressesCopy;
    }

    public boolean[] getPublicNetworkIndicators() {
        int len = this.publicNetworkIndicators.length;
        boolean[] publicNetworkIndicatorsCopy = new boolean[len];
        for (int i = 0; i < len; ++i) {
            publicNetworkIndicatorsCopy[i] = this.publicNetworkIndicators[i];
        }
        return publicNetworkIndicatorsCopy;
    }

    public String[] getMacAddresses() {
        if (this.macAddresses == null) {
            this.macAddresses = new String[this.nicAddresses.length];
        }
        for (int i = 0; i < this.macAddresses.length; ++i) {
            if (this.macAddresses[i] != null) continue;
            this.macAddresses[i] = "";
        }
        String[] macAddressesCopy = new String[this.macAddresses.length];
        System.arraycopy(this.macAddresses, 0, macAddressesCopy, 0, this.macAddresses.length);
        return macAddressesCopy;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getMachineModel() {
        return this.machineModel;
    }

    public String getMachineSerial() {
        return this.machineSerial;
    }

    public String getMTMS() {
        if (this.machineType != null && this.machineModel != null && this.machineSerial != null) {
            return this.machineType + "_" + this.machineModel + "-" + this.machineSerial;
        }
        return "";
    }

    public String toString() {
        StringBuffer returnStringBuffer = new StringBuffer(128);
        returnStringBuffer.append("[MachineId: \n");
        returnStringBuffer.append("Name: ");
        returnStringBuffer.append(this.name);
        returnStringBuffer.append(", Group: ");
        returnStringBuffer.append(this.group);
        String tmpMTMS = this.getMTMS();
        if (!tmpMTMS.equals("")) {
            returnStringBuffer.append(", MTMS: ");
            returnStringBuffer.append(tmpMTMS);
        }
        if (this.nicAddresses != null) {
            for (int i = 0; i < this.nicAddresses.length; ++i) {
                if (this.nicAddresses[i] != null) {
                    returnStringBuffer.append(", NIC Address[");
                    returnStringBuffer.append(i);
                    returnStringBuffer.append("]: ");
                    returnStringBuffer.append(this.nicAddresses[i].getHostName());
                    continue;
                }
                returnStringBuffer.append(", NIC Address[");
                returnStringBuffer.append(i);
                returnStringBuffer.append("]: null");
            }
        }
        return returnStringBuffer.toString();
    }

    public int hashCode() {
        int i;
        int tempHash = 0;
        if (this.nicAddresses != null) {
            for (i = 0; i < this.nicAddresses.length; ++i) {
                if (this.nicAddresses[i] == null) continue;
                tempHash += this.nicAddresses[i].hashCode();
            }
        }
        if (this.publicNetworkIndicators != null) {
            for (i = 0; i < this.publicNetworkIndicators.length; ++i) {
                tempHash += this.publicNetworkIndicators[i] ? 1 : 2;
            }
        }
        if (this.machineType != null) {
            tempHash += this.machineType.hashCode();
        }
        if (this.machineModel != null) {
            tempHash += this.machineModel.hashCode();
        }
        if (this.machineSerial != null) {
            tempHash += this.machineSerial.hashCode();
        }
        return this.name.hashCode() + this.group.hashCode() + new Double(this.version).hashCode() + new Integer(this.type).hashCode() + new Integer(this.fcsVersion).hashCode() + tempHash;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof MachineId) {
            return this.name.equals(((MachineId)o).getName()) && this.group.equals(((MachineId)o).getGroup()) && this.type == ((MachineId)o).getType() && this.fcsVersion == ((MachineId)o).getFcsVersion() && Arrays.equals(this.nicAddresses, ((MachineId)o).getNicAddresses()) && Arrays.equals(this.publicNetworkIndicators, ((MachineId)o).getPublicNetworkIndicators());
        }
        return false;
    }
}

